using System;
using Server;
using Server.Misc;
using Server.Items;
using Server.Factions;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	//[CorpseName( "a wisp corpse" )]
	public class DungeonWisp : Wisp
	{
		private DateTime m_Delay = DateTime.Now;
		private bool m_Dark = false;

		public override Faction FactionAllegiance { get { return null; } }
		public override Ethics.Ethic EthicAllegiance { get { return null; } }

		public override bool AlwaysAttackable { get { return true; } }
		public override bool BleedImmune { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }

		/*
      public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.MortalStrike;
					case 2: return WeaponAbility.ArmorIgnore;
			}
		}
		*/

      [Constructable]
		public DungeonWisp() : this(false)
		{
		}

		[Constructable]
		public DungeonWisp(bool dark)
		{
			m_Dark = dark;
			FightMode = FightMode.Closest;
			SpeechHue = m_Dark ? 2222 : Utility.RandomDyedHue();

			if (m_Dark)
			{
				Body = 165;
				BaseSoundID = 466;
				Name = "a dark wisp";
			}

			SetStr(256, 300);
			SetDex(200, 255);
			SetInt(200, 250);

			SetHits(500, 600);
			SetStam(518, 550);
			SetMana(590, 690);

			SetDamage(18, 20);

			SetResistance(ResistanceType.Physical, 50, 60);
			SetResistance(ResistanceType.Fire, 50, 59);
			SetResistance(ResistanceType.Cold, 50, 60);
			SetResistance(ResistanceType.Poison, 50, 60);
			SetResistance(ResistanceType.Energy, 50, 60);

			SetSkill(SkillName.EvalInt, 50.2, 85.0);
			SetSkill(SkillName.Magery, 70.2, 80.0);
			SetSkill(SkillName.Meditation, 75.1, 100.0);
			SetSkill(SkillName.MagicResist, 86.0, 135.0);
			SetSkill(SkillName.Tactics, 100.1, 101.0);
			SetSkill(SkillName.Wrestling, 90.1, 110.0);

			SetDamageType(ResistanceType.Physical, 50);
			SetDamageType(ResistanceType.Energy, 50);

			Fame = 4000;
			Karma = -2000;

			VirtualArmor = 40;
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			if (typ == 2)
				amount = 0;

			base.OnDamage(amount, from, willKill, typ);

			if (DateTime.Now > m_Delay)
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(15, 30));
				// Effects
				Effects.PlaySound(this.Location, this.Map, 0x29);

				ArrayList targets = Utilitky.GetTargets(this, 8, true);

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.RevealingAction();
					m.BoltEffect(m_Dark ? 1 : 0);

					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(20, 30), m);

					if (m is Xanthos.Interfaces.IEvoCreature)
						auradamage *= 2;

					m.Hits -= auradamage;
					ISTile5.SendDmgPacket(m, auradamage);

					if (m.Hits < 2)
						m.Kill();
				}
			}

			if (from is BaseCreature && Utility.RandomDouble() < 0.1)
			{
				((BaseCreature)from).Pacify(this, DateTime.Now + TimeSpan.FromSeconds(3.0)); // TODO check
				from.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				from.PlaySound(0x207);
			}
		}

		public override void AlterSpellDamageFrom(Mobile from, ref int damage)
		{
			damage = 0;

			if(!KhalAnkur.IsUnderInfluence(from))
			{
				KhalAnkur.Silence(from, this);
			}
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Miscellaneous);
		}

		public override OppositionGroup OppositionGroup
		{
			get { return null; }
		}

		public DungeonWisp(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();

			if (SpeechHue == 2222) m_Dark = true;
		}
	}
}